using System;
using System.Diagnostics;

namespace Implab {
    public class Deferred<T> : IResolvable<T> {
        readonly AbstractPromise<T> m_promise;
        readonly IDispatcher m_dispatcher;

        internal Deferred(AbstractPromise<T> promise, IDispatcher dispatcher) {
            Debug.Assert(promise != null);
            m_promise = promise;
            m_dispatcher = dispatcher;
        }

        public IPromise<T> Promise {
            get { return m_promise; }
        }

        public void Reject(Exception error) {
            m_promise.Reject(error);
        }

        public void Resolve(T value) {
            m_promise.Resolve(value);
        }

        public void Resolve(IPromise<T> thenable) {
            if (thenable == null)
                Reject(new Exception("The promise or task are expected"));
            if (thenable == m_promise)
                Reject(new Exception("The promise cannot be resolved with oneself"));

            else if (m_dispatcher != null)
                // dispatch (see ecma-262/6.0: 25.4.1.3.2 Promise Resolve Functions)
                m_dispatcher.Enqueue(() => Chain(thenable));
            else
                Chain(thenable);
        }

        void Chain(IPromise<T> thenable) {
            try {
                thenable.Then(this);
            } catch (Exception err) {
                Reject(err);
            }
        }
    }
}